



<html>
<head>
  <title>javabog.dk -  - H&aelig;ndelser i grafiske brugergr&aelig;nseflader</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">13 <a name='afsn13'></a>H&aelig;ndelser
i grafiske brugergr&aelig;nseflader</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Forst&aring;
  h&aelig;ndelser og lyttere</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Abonnere p&aring;
  h&aelig;ndelser</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;ttes af
<a href='kapitel21.jsp'>kapitel 21</a>, Avancerede klasser.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;tter
<a href='kapitel11.jsp'>kapitel 11</a>, Grafiske standardkomponenter og 12, Interfaces. <BR>I
eksemplerne anvendes appletter, beskrevet i <a href='kapitel10.jsp'>kapitel 10</a>, Appletter.</P>


<P LANG="da-DK" CLASS="western" STYLE="">H&aelig;ndelser
(eng.: events) spiller en stor rolle i programmering af grafiske
brugergr&aelig;nseflader. N&aring;r brugeren foretager en
handling, f.eks. bev&aelig;ger musen, klikker, trykker en knap ned,
&aelig;ndrer i et tekstfelt osv., opst&aring;r der en <I>h&aelig;ndelse</I>.
I Java er alle h&aelig;ndelser objekter (af typen Event) med metoder
til at unders&oslash;ge de pr&aelig;cise detaljer omkring h&aelig;ndelsen.</P>
<P LANG="da-DK" CLASS="western">H&aelig;ndelser udsendes af de
grafiske komponenter (knapper, vinduer osv.) og hvis man vil behandle
en bestemt type h&aelig;ndelser fra en bestemt grafisk komponent,
skal man &quot;lytte&quot; efter den h&aelig;ndelse. Det g&oslash;res
ved at registrere en <I>lytter</I> (eng.: listener) p&aring;
komponenten.</P>
<P LANG="da-DK" CLASS="western">N&aring;r en lytter til en bestemt
slags h&aelig;ndelser er registreret hos en komponent, bliver
der kaldt en metode p&aring; lytteren, n&aring;r den p&aring;g&aelig;ldende
slags h&aelig;ndelser indtr&aelig;ffer (f.eks. kaldes mouseClicked(),
n&aring;r der klikkes med musen). For at sikre, at lytteren har den
p&aring;g&aelig;ldende metode, skal lytter-objektet implementere et
interface, der garanterer, at det har metoden.</P>
<P LANG="da-DK" CLASS="western">Eksempel: Paneler (JPanel) kan
udsende h&aelig;ndelser af typen MouseEvent. Klassen JPanel har
derfor metoden addMouseListener(MouseListener lytter), der kan bruges
til at registrere lytter-objekter i vinduet. Det er kun objekter af
typen MouseListener, der kan registreres som lyttere. MouseListener
er et interface, s&aring; man skal lave en klasse, der implementerer
MouseListener og skabe lytter-objekter ud fra dette. N&aring;r
brugeren f.eks. klikker med musen i vinduet, udsender det en
MouseEvent-h&aelig;ndelse til alle lytter-objekter, der er blevet
registreret vha. addMouseListener(). Det g&oslash;r vinduet ved
at kalde metoden mouseClicked(MouseEvent h&aelig;ndelse) p&aring;
lytter-objekterne.</P>
<H2 CLASS="western">13.1 <a name='afsn13.1'></a>Eksempel: LytTilMusen</SPAN></H2>
<P LANG="da-DK" CLASS="western">Herunder definerer vi klassen
Muselytter, der implementerer MouseListener og skriver ud til
sk&aelig;rmen, hver gang der sker noget med musen.</P>
<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;

public class Muselytter <B>implements MouseListener</B>
{
  public void mousePressed(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    Point trykpunkt = h&aelig;ndelse.getPoint();
    System.out.println(&quot;Mus trykket ned i &quot;+trykpunkt);
  }

  public void mouseReleased(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    Point slippunkt = h&aelig;ndelse.getPoint();
    System.out.println(&quot;Mus sluppet i &quot;+slippunkt);
  }

  public void mouseClicked(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    System.out.println(&quot;Mus klikket i &quot;+h&aelig;ndelse.getPoint());
  }

<I>  //--------------------------------------------------------------------</I>
<I>  //  Ubrugte h&aelig;ndelser (skal defineres for at implementere MouseListener)</I>
<I>  //--------------------------------------------------------------------</I>
  public void mouseEntered (MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
  public void mouseExited (MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
}</PRE><P LANG="da-DK" CLASS="western" ALIGN=LEFT>
Lad os nu lave et grafisk objekt, der:</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western" ALIGN=LEFT>Opretter et
  muselytter-objekt.</P>
  <LI><P LANG="da-DK" CLASS="western" ALIGN=LEFT>Registrerer
  lytter-objektet, s&aring; det f&aring;r kaldt sine metoder, n&aring;r
  der sker noget med musen.</P>
</OL>



<PRE CLASS="kode-western">import javax.swing.*;
public class LytTilMusen extends JPanel
{
  public LytTilMusen()
  {
    Muselytter lytter = new Muselytter();
    <B>this.addMouseListener(lytter)</B>;  <I>// this er panelet selv</I>
  }
}</PRE><P LANG="da-DK" CLASS="western">
Her er et eksempel p&aring; uddata fra programmet:</P>
<PRE CLASS="kode-western">Mus trykket ned i java.awt.Point[x=132,y=209]
Mus sluppet i java.awt.Point[x=139,y=251]
Mus trykket ned i java.awt.Point[x=101,y=199]
Mus sluppet i java.awt.Point[x=101,y=199]
Mus klikket i java.awt.Point[x=101,y=199]</PRE><H2 CLASS="western">
13.2 <a name='afsn13.2'></a>Eksempel: Linjetegning</SPAN></H2>
<P LANG="da-DK" CLASS="western">Det foreg&aring;ende eksempel giver
ikke panelet besked om, at der er sket en h&aelig;ndelse. Det har man
brug for, hvis man f.eks. vil tegne noget p&aring; panelet.</P>
<P LANG="da-DK" CLASS="western">Herunder er et eksempel, hvor
lytter-objektet (Linjelytter) giver informationer om klik videre
til panelet (Linjetegning), s&aring;dan at en bl&aring; linje tegnes
mellem det punkt, hvor man trykkede museknappen ind og det punkt,
hvor man slap museknappen. 
</P>
<PRE CLASS="kode-western">import java.awt.*;
import javax.swing.*;

public class Linjetegning extends JPanel
{
  public Point trykpunkt;
  public Point slippunkt;

  public Linjetegning()
  {
<B>    Linjelytter lytter = new Linjelytter();</B>
    <B>lytter.panelet = this;</B> <I>// initialiserer lytterens reference til panelet</I>
    <B>this.addMouseListener(lytter)</B>;
  }

  public void paintComponent(Graphics g)
  {
    super.paintComponent(g);            <I>// tegn f&oslash;rst baggrunden p&aring; panelet</I>
    g.drawString(&quot;1:&quot;+trykpunkt+&quot;  2:&quot;+slippunkt,10,10);
    if (trykpunkt != null &amp;&amp; slippunkt != null)
    {
      g.setColor(Color.BLUE);
      g.drawLine(trykpunkt.x, trykpunkt.y, slippunkt.x, slippunkt.y);
    }
  }
}</PRE><P LANG="da-DK" CLASS="western" STYLE="">
Lytteren skal give panelet besked om klik vha. panelets to variabler,
<FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">trykpunkt</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">slippunkt</SPAN></SPAN></FONT></FONT>.
Derfor er Linjelytter n&oslash;dt til at have en reference (af type
Linjetegning) til panelet:</P>
<PRE CLASS="kode-western">import java.awt.event.*;

public class Linjelytter implements MouseListener
{
<B>  public Linjetegning panelet;                 </B><I>// Reference til panelet</I>

  public void mousePressed(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    <B>panelet.trykpunkt = </B>h&aelig;ndelse.getPoint();
  }

  public void mouseReleased(MouseEvent h&aelig;ndelse) <I>// kr&aelig;ves af MouseListener</I>
  {
    <B>panelet.slippunkt = </B>h&aelig;ndelse.getPoint();
    <B>panelet.repaint()</B>; <I>// Gentegn panelet lige om lidt.</I>
  }

<I>  //--------------------------------------------------------------------</I>
<I>  //  Ubrugte h&aelig;ndelser (skal defineres for at implementere interfacet)</I>
<I>  //--------------------------------------------------------------------</I>
  public void mouseClicked(MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
  public void mouseEntered (MouseEvent event) {} <I>// kr&aelig;ves af MouseListener</I>
  public void mouseExited (MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
}</PRE>
<P LANG="da-DK" CLASS="western">Med linjen</P>
<PRE CLASS="kode-western">    panelet.repaint();</PRE><P LANG="da-DK" CLASS="western">
fort&aelig;ller vi Linjetegning-panelet, at den skal gentegne sig
selv. Det for&aring;rsager kort efter et kald til dens
paintComponent()-metode.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog14_html_m5187545.png" NAME="grafik23" ALIGN=BOTTOM BORDER=0></P>
<P LANG="da-DK" CLASS="western">Her er en klasse der viser dette og
alle de andre paneler i dette kapitel, i hvert sit faneblad
(beskrevet i <a href='kapitel11.jsp#afsn11.4.6'>afsnit 11.4.6</a>).</P>
<PRE CLASS="kode-western">import javax.swing.*;
public class BenytAltKapitel13
{
  public static void main(String[] arg)
  {
    JTabbedPane faneblade = new JTabbedPane();
    faneblade.add(&quot;1 LytTilMusen&quot;, new LytTilMusen());
    faneblade.add(&quot;2 Linjetegning&quot;, new Linjetegning());
    faneblade.add(&quot;3 Linjetegning2&quot;, new Linjetegning2());
    faneblade.add(&quot;4 Kruseduller&quot;, new Kruseduller());
    faneblade.add(&quot;5 LytTilKnap&quot;, new LytTilKnap());
    faneblade.add(&quot;6 Tastetryk&quot;, new Tastetryk());
    JFrame vindue = new JFrame(&quot;BenytAltKapitel13&quot;);
    vindue.add( faneblade );
    vindue.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE); <I>// reag&eacute;r p&aring; luk</I>
    vindue.pack();                  <I>// lad vinduet selv bestemme sin st&oslash;rrelse</I>
    vindue.setVisible(true);                                  <I>// &aring;bn vinduet</I>
  }
}</PRE>

<H3 CLASS="western" STYLE="">13.2.1 <a name='afsn13.2.1'></a>Linjetegning
i &eacute;n klasse</H3>
<P LANG="da-DK" CLASS="western">Herunder er Linjetegning igen, men nu
som et panel, der <I>selv</I> implementerer MouseListener. Det
er linjen:</P>
<PRE CLASS="kode-western">    this.addMouseListener(this);</PRE><P LANG="da-DK" CLASS="western">
der registrerer panel-objektet selv som lytter.</P>

<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Linjetegning2 extends JPanel <B>implements MouseListener</B>
{
  private Point trykpunkt;
  private Point slippunkt;

  public Linjetegning2()
  {
    <B>this.addMouseListener(this)</B>;
  }

  public void paintComponent(Graphics g)
  {
    super.paintComponent(g);            <I>// tegn f&oslash;rst baggrunden p&aring; panelet</I>
    g.drawString(&quot;1:&quot;+trykpunkt+&quot;  2:&quot;+slippunkt,10,10);
    if (trykpunkt != null &amp;&amp; slippunkt != null)
    {
      g.setColor(Color.BLUE);
      g.drawLine(trykpunkt.x, trykpunkt.y, slippunkt.x, slippunkt.y);
    }
  }

  public void mousePressed(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    trykpunkt = h&aelig;ndelse.getPoint();
  }

  public void mouseReleased(MouseEvent h&aelig;ndelse)  <I>// kr&aelig;ves af MouseListener</I>
  {
    slippunkt = h&aelig;ndelse.getPoint();
    repaint();
  }

<I>  //--------------------------------------------------------------------</I>
<I>  //  Ubrugte h&aelig;ndelser (skal defineres for at implementere interfacet)</I>
<I>  //--------------------------------------------------------------------</I>
  public void mouseClicked(MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
  public void mouseEntered (MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
  public void mouseExited (MouseEvent event) {}  <I>// kr&aelig;ves af MouseListener</I>
}</PRE><P LANG="da-DK" CLASS="western">
Bem&aelig;rk, at nu kan <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">trykpunkt</SPAN></SPAN></FONT></FONT>
og <FONT FACE="Courier, monospace"><FONT SIZE=2 STYLE="font-size: 9pt"><SPAN STYLE="font-weight: medium"><SPAN STYLE="background: transparent">slippunkt</SPAN></SPAN></FONT></FONT>
v&aelig;re private i stedet for public, fordi de ikke beh&oslash;ver
at v&aelig;re tilg&aelig;ngelige udefra.</P>
<H2 CLASS="western">13.3 <a name='afsn13.3'></a>Ekstra eksempler</SPAN></H2>
<P LANG="da-DK" CLASS="western">Ovenfor har vi brugt MouseListener
som illustration. Her vil vi give eksempler p&aring; brug af de andre
typer lyttere (beskrevet i appendiks senere i kapitlet).</P>
<H3 CLASS="western">13.3.1 <a name='afsn13.3.1'></a>Lytte til musebev&aelig;gelser</H3>
<P LANG="da-DK" CLASS="western">Med MouseMotionListener f&aring;r man
adgang til h&aelig;ndelserne mouseMoved og mouseDragged. Det kan
bruges til at tegne grafiske figurer ved at hive musen hen over
sk&aelig;rmen. 
</P>
<P LANG="da-DK" CLASS="western">Herunder er et panel, man kan tegne
kruseduller p&aring;. Vi husker punktet, n&aring;r musen trykkes ned
(mousePressed()) og tegner en linje fra forrige punkt til musen, n&aring;r
den tr&aelig;kkes med nedtrykket knap (mouseDragged()).</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog14_html_m22a68d61.png" NAME="grafik24" ALIGN=BOTTOM BORDER=0></P>
<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Kruseduller extends JPanel
                         implements MouseListener,<B> MouseMotionListener</B>
{
  public Kruseduller()
  {
    this.addMouseListener(this);
    <B>this.addMouseMotionListener(this);</B>
  }

  Point punkt;

  public void mousePressed(MouseEvent h&aelig;ndelse) <I>// kr&aelig;ves af MouseListener</I>
  {
    punkt = h&aelig;ndelse.getPoint();
  }

  public void mouseDragged(MouseEvent h&aelig;ndelse) <I>// kr&aelig;ves af MouseMotionListener</I>
  {
    Point gammeltPunkt = punkt;
    punkt =   h&aelig;ndelse.getPoint();
    Graphics g = getGraphics();
    g.drawLine(gammeltPunkt.x, gammeltPunkt.y, punkt.x, punkt.y);
  }

  public void mouseReleased (MouseEvent h&aelig;ndelse){} <I>// kr&aelig;ves af MouseListener</I>
  public void mouseClicked (MouseEvent event) {}    <I>// kr&aelig;ves af MouseListener</I>
  public void mouseEntered (MouseEvent event) {}    <I>// kr&aelig;ves af MouseListener</I>
  public void mouseExited (MouseEvent event) {}     <I>// kr&aelig;ves af MouseListener</I>
  public void mouseMoved (MouseEvent h&aelig;ndelse){} <I>//kr&aelig;ves af MouseMotionListener</I>
}</PRE><P LANG="da-DK" CLASS="western">
Her sker tegningen af grafikken direkte i h&aring;ndteringen af
h&aelig;ndelsen. Da vi ikke husker de gamle punkter, kan vi ikke
gentegne krusedullen, hvis systemet kalder paintComponent().</P>
<H3 CLASS="western">13.3.2 <a name='afsn13.3.2'></a>Lytte til en knap</H3>
<P LANG="da-DK" CLASS="western">Det vigtigste interface til
programmering af grafiske brugergr&aelig;nseflader er ActionListener
med metoden actionPerformed(). Den bruges bl.a. til at lytte til, om
knapper bliver trykket p&aring;. Her er et eksempel, hvor den tekst,
der er valgt med musen i et tekstomr&aring;de, bliver kopieret til
det andet tekstomr&aring;de, n&aring;r man trykker p&aring; knappen.</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm">
<IMG SRC="bog14_html_23735040.png" NAME="grafik25" ALIGN=BOTTOM BORDER=0></P>

<PRE CLASS="kode-western" STYLE="">import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class LytTilKnap extends JPanel <B>implements ActionListener</B>
{
  private JTextArea t1, t2;
  private JButton kopierKnap;

  public LytTilKnap()
  {
    setLayout(new FlowLayout());
    String s = &quot;Her er en tekst.\nMark&eacute;r noget af\nden og tryk\nKopier...&quot;;
    t1 = new JTextArea(s, 5,15);
    add(t1);
    kopierKnap = new JButton(&quot;Kopi&eacute;r&gt;&gt;&quot;);
    <B>kopierKnap.addActionListener(this)</B>;
    add(kopierKnap);
    t2 = new JTextArea( 5,15);
    t2.setEditable(false);
    add(t2);
  }

  public void actionPerformed(ActionEvent e)   <I>// kr&aelig;ves af ActionListener</I>
  {
    t2.setText(t1.getSelectedText() );
  }
}</PRE><P LANG="da-DK" CLASS="western">
L&aelig;g m&aelig;rke til, at vi registrerer lytteren (som er
panel-objektet selv) hos knappen.</P>
<H3 CLASS="western">13.3.3 <a name='afsn13.3.3'></a>Lytte efter tastetryk</H3>
<P LANG="da-DK" CLASS="western">Vores sidste eksempel er med
KeyListener-interfacet, der tillader at lytte efter tastetryk.</P>
<P LANG="da-DK" CLASS="western">Programmet herunder viser en tekst.
Hver gang der tastes et bogstav, bliver det tilf&oslash;jet teksten.
Med piletasterne kan man rykke teksten op og ned. Retur-tasten
sletter teksten.</P>
<PRE CLASS="kode-western">import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Tastetryk extends JPanel implements KeyListener
{
  String tekst = &quot;tast noget - pil op/ned rykker teksten &quot;;
  <IMG SRC="bog14_html_m336bb151.png" NAME="grafik26" ALIGN=RIGHT BORDER=0>Point pos = new Point(20,20);

  public Tastetryk()
  {
    addKeyListener(this);
    requestFocus();
  }

  public void paintComponent(Graphics g)
  {
    super.paintComponent(g);            <I>// tegn f&oslash;rst baggrunden p&aring; panelet</I>
    g.drawString(tekst, pos.x, pos.y);
  }

  public void keyPressed(KeyEvent e)
  {
    if (e.getKeyCode() == KeyEvent.VK_ENTER) tekst = &quot;tekst: &quot;;
    else if (e.getKeyCode() == KeyEvent.VK_UP)   pos.y = pos.y - 10;
    else if (e.getKeyCode() == KeyEvent.VK_DOWN) pos.y = pos.y + 10;
    else tekst = tekst + e.getKeyChar();
    repaint();
  }

  public void keyReleased(KeyEvent e) {} <I>// kr&aelig;ves af KeyListener</I>
  public void keyTyped(KeyEvent e)    {} <I>// kr&aelig;ves af KeyListener</I>
}</PRE>
<H2 CLASS="western" STYLE="">13.4 <a name='afsn13.4'></a>Appendiks</SPAN></H2>
<H3 CLASS="western">13.4.1 <a name='afsn13.4.1'></a>Lyttere og deres metoder</H3>
<P LANG="da-DK" CLASS="western">Det f&oslash;lgende er en oversigt
over lytter-interfaces og deres h&aelig;ndelser (de ligger alle i
pakken java.awt.event).</P>
<H4 CLASS="western">ActionListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen ActionEvent sendes af
den p&aring;g&aelig;ldende komponent, n&aring;r brugeren klikker p&aring;
en knap, trykker retur i et tekstfelt, v&aelig;lger noget i et
afkrydsningsfelt, radioknap, menu eller lignende.</P>
<PRE CLASS="ikke-javakode-western">public interface ActionListener {
    public void actionPerformed(ActionEvent e); 
}</PRE><H4 CLASS="western">
ComponentListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen ComponentEvent sendes
af alle grafiske komponenter (JButton, JTextField, JCheckBox osv. og
JFrame, JApplet, JPanel,...), n&aring;r de hhv. &aelig;ndrer
st&oslash;rrelse, position, bliver synlige eller usynlige.</P>
<PRE CLASS="ikke-javakode-western">public interface ComponentListener {
    public void componentResized(ComponentEvent e); 
    public void componentMoved(ComponentEvent e); 
    public void componentShown(ComponentEvent e); 
    public void componentHidden(ComponentEvent e);
}</PRE><H4 CLASS="western">
FocusListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen FocusEvent sendes af
komponenter, n&aring;r de f&aring;r fokus (dvs. hvis brugere trykker
p&aring; en tast, vil det p&aring;virke netop denne komponent).
Kun en komponent har fokus ad gangen<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</P>
<PRE CLASS="ikke-javakode-western">public interface FocusListener {
    public void focusGained(FocusEvent e);
    public void focusLost(FocusEvent e);
}</PRE><H4 CLASS="western">
ItemListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen ItemEvent sendes af
afkrydsningsfelter og radioknapper, n&aring;r en mulighed bliver
krydset af eller fravalgt.</P>
<PRE CLASS="ikke-javakode-western">public interface ItemListener {
    void itemStateChanged(ItemEvent e); 
}</PRE><H4 CLASS="western">
KeyListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelser af typen KeyEvent
sendes af komponenten, der har tastaturfokus. keyPressed() kaldes,
n&aring;r en tast bliver trykket ned (bem&aelig;rk, at der godt kan
v&aelig;re flere taster trykket ned samtidig, f.eks. Ctrl og C) og
keyReleased(), n&aring;r den bliver sluppet. Er man mere overordnet
interesseret i, hvad brugeren taster ind, b&oslash;r man benytte
keyTyped(), der svarer til, at brugeren har trykket en tast ned og
sluppet den igen.</P>
<PRE CLASS="ikke-javakode-western">public interface KeyListener {
    public void keyTyped(KeyEvent e);
    public void keyPressed(KeyEvent e);
    public void keyReleased(KeyEvent e);
}</PRE>
<H4 CLASS="western" STYLE="">MouseListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen MouseEvent kan sendes
af alle grafiske komponenter. mousePressed() kaldes, n&aring;r en
museknap bliver trykket ned og mouseReleased(), n&aring;r den bliver
sluppet igen. Er man mere overordnet interesseret i at vide, om
brugeren har klikket et sted (trykket ned og sluppet p&aring; det
samme sted), b&oslash;r man benytte mouseClicked(). mouseEntered() og
mouseExited() sendes, n&aring;r musen g&aring;r ind over hhv.
v&aelig;k fra komponenten.</P>
<PRE CLASS="ikke-javakode-western">public interface MouseListener {
    public void mousePressed(MouseEvent e);
    public void mouseReleased(MouseEvent e);
    public void mouseClicked(MouseEvent e);

    public void mouseEntered(MouseEvent e);
    public void mouseExited(MouseEvent e);
}</PRE><H4 CLASS="western">
MouseMotionListener</H4>
<P LANG="da-DK" CLASS="western">Kan sendes af alle grafiske
komponenter. mouseDragged() kaldes, n&aring;r en museknap er trykket
ned og hives (bev&aelig;ges, mens museknappen forbliver trykket ned).
mouseMoved() svarer til, at musen flyttes (uden nogle knapper trykket
ned).</P>
<PRE CLASS="ikke-javakode-western">public interface MouseMotionListener {
    public void mouseDragged(MouseEvent e);
    public void mouseMoved(MouseEvent e);
}</PRE><H4 CLASS="western">
TextListener</H4>
<P LANG="da-DK" CLASS="western">Sendes af tekstfelter (JTextField og
JTextArea), n&aring;r brugeren &aelig;ndrer teksten.</P>
<PRE CLASS="ikke-javakode-western">public interface TextListener {
    public void textValueChanged(TextEvent e); 
}</PRE><H4 CLASS="western">
WindowListener</H4>
<P LANG="da-DK" CLASS="western">H&aelig;ndelsen WindowEvent sendes af
vinduer (Frame og Dialog), n&aring;r de &aring;bnes, fors&oslash;ges
lukket, lukkes, minimeres, gendannes, f&aring;r fokus og mister
fokus.</P>
<PRE CLASS="ikke-javakode-western">public interface WindowListener {
    public void windowOpened(WindowEvent e);
    public void windowClosing(WindowEvent e);
    public void windowClosed(WindowEvent e);
    public void windowIconified(WindowEvent e);
    public void windowDeiconified(WindowEvent e);
    public void windowActivated(WindowEvent e);
    public void windowDeactivated(WindowEvent e);
}</PRE>
<P LANG="da-DK" CLASS="western">Det er dette interface, der skal
implementeres, hvis man vil fange, n&aring;r brugeren vil lukke
vinduet og s&oslash;rge for, at programmet stopper. Eksempel:</P>
<PRE CLASS="kode-western">import java.awt.event.*;
public class LukProgram implements WindowListener {
  public void windowOpened(WindowEvent e) {};
<B>  public void windowClosing(WindowEvent e) { System.exit(0); }</B>
  public void windowClosed(WindowEvent e) {};
  public void windowIconified(WindowEvent e) {};
  public void windowDeiconified(WindowEvent e) {};
  public void windowActivated(WindowEvent e) {};
  public void windowDeactivated(WindowEvent e) {};
}</PRE><P LANG="da-DK" CLASS="western">
Klassen kan bruges fra dine egne programmer, ved at tilf&oslash;je et
LukProgram-objekt til et vindue, som lytter:</P>
<PRE CLASS="kode-western">    vindue.addWindowListener( new LukProgram() );</PRE><P LANG="da-DK" CLASS="western">
Dette svarer s&aring;ledes til at kalde
setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE).</P>
<H2 CLASS="western" STYLE="">13.5 <a name='afsn13.5'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel13.jsp#afsn13.5">
  <input type='checkbox' name='vis' value='13.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='13.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">
13.5.2 <a name='afsn13.5.2'></a>Adaptere</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel13.jsp#afsn13.5.2">
  <input type='checkbox' name='vis' value='13.5.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='13.5.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P LANG="da-DK" CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Man
  kan anmode om fokus p&aring; en komponent ved at kalde
  requestFocus() p&aring; den.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel12.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel14.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
